{ Ejemplo de utilizacin de Google Maps en Delphi.
  by  Neftal  -Germn Estvez-  2009
  http://neftali.clubdelphi.com

  NOTA: Este ejemplo y su cdigo es de libre distribucin. Si te es de utilidad,
  tienes sugerencias, comentarios o errores puedes escribirlos en mi web.
  Todos ellos sern bienvenidos.  ;-D
  http://neftali.clubdelphi.com

  NOTE: This sampole and its code is freely distributed. If you are useful,
   have suggestions, comments or errors can post it to my website.
   All of them are welcome. ;-D
   http://neftali.clubdelphi.com
}
unit FMapa;

//=========================================================================
//
// I N T E R F A C E
//
//=========================================================================
interface

uses
  SHDocVw, Controls, StdCtrls, Classes, OleCtrls, Forms, ExtCtrls;

type

  // Array de strings
  TArrString = array of string;

  // Clase para el form de mapa
  TFormMapa = class(TForm)
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    pnlMapa: TPanel;
    WebBrowser1: TWebBrowser;
    procedure FormShow(Sender: TObject);
    procedure WebBrowser1DocumentComplete(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private

  public
    TSWeb:TStrings;
    FNameWeb:String;

    // Cargar el mapa
    procedure LoadMapa(H, W:integer; AControls:TArrString;
                       AVisibleMark:Boolean;
                       LatMarca, LonMarca:string;
                       AMapType:string='G_NORMAL_MAP');
  end;

var
  FormMapa: TFormMapa;


const
  STR_LATMARCA_RAL = '41.381655';
  STR_LONMARCA_RAL = '2.122829';
  STR_EMPTY = '';



//=========================================================================
//
// I M P L E M E N T A T I O N
//
//=========================================================================
implementation

uses
  SysUtils, Dialogs, MSHTML, FOpciones;

{$R *.dfm}



procedure TFormMapa.LoadMapa(H, W: integer; AControls:TArrString;
                             AVisibleMark:Boolean;
                             LatMarca, LonMarca:string;
                             AMapType:string='G_NORMAL_MAP');
var
  Str:string;
  i:Integer;



  //
  procedure _AddMarca();
  const
    STR_PREFIX_MARCA = '##MARCA##';
    STR_MARCA1 = '        var point = new GLatLng(%s,%s);';
    STR_MARCA2 = '        var marker = new GMarker(point);';
    STR_MARCA3 = '        map.addOverlay(marker);';
  var
    i, j:Integer;
    str, line:string;
  begin

    // Buscar la cadena
    for i := 0 to (TSWeb.Count - 1) do begin
      line := FormMapa.TSWeb[i];
      j := AnsiPos(STR_PREFIX_MARCA, line);
      // Es la lnea
      if (j > 0) then begin
        if (AVisibleMark) then begin
          Str := Format(STR_MARCA1,[LatMarca, LonMarca]);
          FormMapa.TSWeb[i] := Str;
          FormMapa.TSWeb.Insert(i+1, STR_MARCA3);
          FormMapa.TSWeb.Insert(i+1, STR_MARCA2);
        end
        else begin
          FormMapa.TSWeb[i] := STR_EMPTY;
        end;

        // Grabar
        FormMapa.TSWeb.SaveToFile(FormMapa.FNameWeb);

        Break;
      end;
    end;
  end;
  //
  procedure _AddVentana();
  const
    STR_PREFIX_VENTANA = '##VENTANA##';
    STR_VENTANA = '       marker.openInfoWindowHtml(html);';
  var
    i, j:Integer;
    str, line:string;
  begin

    // Buscar la cadena
    for i := 0 to (TSWeb.Count - 1) do begin
      line := FormMapa.TSWeb[i];
      j := AnsiPos(STR_PREFIX_VENTANA, line);
      // Es la lnea
      if (j > 0) then begin
        if (AVisibleMark) then begin
          FormMapa.TSWeb[i] := STR_VENTANA;
        end
        else begin
          FormMapa.TSWeb[i] := STR_EMPTY;
        end;

        // Grabar
        FormMapa.TSWeb.SaveToFile(FormMapa.FNameWeb);

        Break;
      end;
    end;
  end;
  //
  procedure _ChangeSize();
  const
    STR_PREFIX_TAM = '##TAMANYO##';
    STR_TAM = '<div id="map" style="width: %dpx; height: %dpx"></div>';
  var
    i, j:Integer;
    str, line:string;
  begin

    // Buscar la cadena
    for i := 0 to (TSWeb.Count - 1) do begin
      line := FormMapa.TSWeb[i];
      j := AnsiPos(STR_PREFIX_TAM, line);
      // Es la lnea
      if (j > 0) then begin
        Str := Format(STR_TAM,[W, H]);
        FormMapa.TSWeb[i] := Str;
        FormMapa.TSWeb.SaveToFile(FormMapa.FNameWeb);

        Break;
      end;
    end;
  end;
  //
  procedure _ChangeMapType();
  const
    STR_PREFIX_TYPE = '##MAPTYPE##';
    STR_TYPE = '        map.setMapType(%s);';
  var
    i, j:Integer;
    str, line:string;
  begin

    // Buscar la cadena
    for i := 0 to (TSWeb.Count - 1) do begin
      line := FormMapa.TSWeb[i];
      j := AnsiPos(STR_PREFIX_TYPE, line);
      // Es la lnea
      if (j > 0) then begin
        Str := Format(STR_TYPE,[AMapTYpe]);
        FormMapa.TSWeb[i] := Str;
        FormMapa.TSWeb.SaveToFile(FormMapa.FNameWeb);

        Break;
      end;
    end;
  end;
  //
  procedure _AddControls();
  const
    STR_PREFIX_CONTROLS = '##CONTROLS##';
    STR_CONTROL_STRING = '        map.addControl(new %s());';
  var
    i, j, k:Integer;
    str, line:string;
  begin
    // Buscar la cadena
    for i := 0 to (TSWeb.Count - 1) do begin
      line := FormMapa.TSWeb[i];
      j := AnsiPos(STR_PREFIX_CONTROLS, line);
      // Es la lnea
      if (j > 0) then begin
        // Eliminar
        FormMapa.TSWeb.Delete(i);

        // Aadir los controles
        for k := 0 to (Length(AControls)-1) do begin
          Str := AControls[k];
          FormMapa.TSWeb.Insert(i, Format(STR_CONTROL_STRING,[Str]));
        end;

        // Grabar
        FormMapa.TSWeb.SaveToFile(FormMapa.FNameWeb);

        Break;
      end;
    end;
  end;
  //
  
begin

  // Tamao del form
  Self.Height := H + 65;
  Self.Width := W + 50;

  // Crgar la pgina en memoria
  TSWeb.LoadFromFile(ExtractFilePath(ParamStr(0)) + '_Mapa.html');

  // Ajustar tamao
  _ChangeSize();
  _AddControls();
  _ChangeMapTYpe();
  _AddMarca();
  _AddVentana();

  // Load the HTML page
  WebBrowser1.Navigate(FNameWeb);

  // Form de opciones
  FormOpciones.Show;
end;

procedure TFormMapa.FormShow(Sender: TObject);
var
  arr:TArrString;
begin

  // ini
  TSWeb := TStringList.Create();

  // Store screen fonts in combo box and disabled it
  ComboBox1.Items.Assign(Screen.Fonts);
  ComboBox1.Enabled := False;

  // inicial
  FNameWeb := ExtractFilePath(ParamStr(0)) + 'Mapa.html';
  SetLength(arr, 3);
  arr[0] := 'GLargeMapControl';
  arr[1] := 'GSmallZoomControl';
  arr[2] := 'GMapTypeControl';

  LoadMapa(400, 400, arr, True, STR_LATMARCA_RAL, STR_LONMARCA_RAL);

  // Valores iniciales
  FormOpciones.SetMapControl('GLargeMapControl', True);
  FormOpciones.SetMapControl('GSmallZoomControl', True);
  FormOpciones.SetMapControl('GMapTypeControl', True);

end;

procedure TFormMapa.WebBrowser1DocumentComplete(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
  { Document loaded: enable combo box }
var
  Doc: IHTMLDocument2;      // current HTML document
begin
  ComboBox1.Enabled := True;

  // ocultar barras de desplazamiento
  Doc := WebBrowser1.Document as IHTMLDocument2;
  Doc.Body.Style.overflow := 'hidden';

end;

procedure TFormMapa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  // lIBERAR
  FreeAndNil(TSWeb);
end;



end.

